#!/usr/bin/python
# -*- coding: UTF-8 -*-
#import chardet
import os
import sys 
import time
import logging
import st7796
import gt911
from PIL import Image, ImageDraw, ImageFont
import RPi.GPIO as GPIO

if __name__ == '__main__':
    disp = st7796.st7796()
    disp.clear()
    touch = gt911.gt911()  # The interrupt is already bound during driver initialization
    
    logging.info("show image")
    ImagePath = ["./pic/img_4.jpg", "./pic/img_5.jpg", "./pic/img_6.jpg", "./pic/img_7.jpg"]
    for i in range(0, 4):
        image = Image.open(ImagePath[i])    
        disp.show_image(image)
        time.sleep(0.5)
    disp.clear()

    try:
        while True:
            time.sleep(0.1)

            if GPIO.input(4) == GPIO.LOW:  # Check if the interrupt pin is low (indicating a touch event)
                print("Touch detected!")
                # If there is a touch point, draw a rectangle
                if touch.last_x != -1 and touch.last_y != -1:
                    disp.dre_rectangle(
                        touch.last_x, touch.last_y,
                        touch.last_x + 5, touch.last_y + 5,
                        0x00ff  # color
                    )
    
                    print(f"x={touch.last_x}, y={touch.last_y}")
                    touch.last_x = -1  # Reset coordinates
                    touch.last_y = -1
            else:
                print("No touch detected")
                # time.sleep(0.1)  # Delay

    except KeyboardInterrupt:
        print("Program terminated")
        GPIO.cleanup()
