import smbus

def scan_i2c():
    # Create SMBus object representing the I2C-1 bus
    bus = smbus.SMBus(1)  # Raspberry Pi's I2C-1 bus is numbered 1
    devices = []

    # Scan I2C addresses from 0x03 to 0x77
    for address in range(0x03, 0x78):
        try:
            # Try to read a byte from each address to check if the device responds
            bus.read_byte(address)
            devices.append(hex(address))
        except OSError:
            # If the address doesn't respond, continue scanning
            pass
    
    if devices:
        print("I2C devices found at the following addresses:")
        for device in devices:
            print(f" - {device}")
    else:
        print("No I2C devices found.")
    
    # Close the I2C bus
    bus.close()

if __name__ == '__main__':
    scan_i2c()
