import smbus2
import time

GT911_I2C_ADDR = 0x5D  # Adjust according to the actual address
START_REG = 0x8047
END_REG = 0x80FE

# Initialize I2C bus
bus = smbus2.SMBus(1)

def read_register(register, length=1):
    """Read register"""
    bus.write_i2c_block_data(GT911_I2C_ADDR, register >> 8, [register & 0xFF])
    time.sleep(0.01)  # Wait for the device to respond
    data = bus.read_i2c_block_data(GT911_I2C_ADDR, register >> 8, length)
    return data if length > 1 else data[0]

def read_gt911_config():
    config_data = []
    # Loop through the registers from START_REG to END_REG and read data
    for reg in range(START_REG, END_REG + 1):
        value = read_register(reg)
        config_data.append(value)
    return config_data

# Read GT911 configuration
config = read_gt911_config()

# Print the configuration data in a format suitable for C code
print("const uint8_t CTP_CFG_GT911[] = {")
for i in range(0, len(config), 10):
    chunk = config[i:i+10]  # Group the data in chunks of 10 bytes
    line = ", ".join(f"0x{byte:02X}" for byte in chunk)
    print(f"  {line},")  # Print each chunk with formatting
print("};")
